/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonFaintedEvent;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.DespawnBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.DespawnReason;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u001d\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastDespawn;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/class_2338;", "coords", "Lnet/minecraft/class_2960;", "biome", "dimension", "Lnet/minecraft/class_3218;", "level", "Lus/timinc/mc/cobblemon/spawnnotification/util/DespawnReason;", "reason", "", "broadcast", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/class_2338;Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/minecraft/class_3218;Lus/timinc/mc/cobblemon/spawnnotification/util/DespawnReason;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "evt", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;)V", "Lnet/minecraft/class_1297;", "entity", "(Lnet/minecraft/class_1297;Lnet/minecraft/class_3218;)V", "<init>", "()V", "cobblemon-spawn-notification"})
public final class BroadcastDespawn {
    @NotNull
    public static final BroadcastDespawn INSTANCE = new BroadcastDespawn();

    private BroadcastDespawn() {
    }

    public final void handle(@NotNull PokemonCapturedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastDespawns()) {
            return;
        }
        EmptyPokeBallEntity entity = evt.getPokeBallEntity();
        class_2338 coords = entity.method_24515();
        class_1937 level = entity.method_37908();
        if (!(level instanceof class_3218)) {
            return;
        }
        Pokemon pokemon = evt.getPokemon();
        Intrinsics.checkNotNullExpressionValue((Object)coords, (String)"coords");
        class_2960 class_29602 = ((class_5321)level.method_23753(coords).method_40230().get()).method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"level.getBiome(coords).key.get().value");
        class_2960 class_29603 = ((class_3218)level).method_44013().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"level.dimensionKey.value");
        this.broadcast(pokemon, coords, class_29602, class_29603, (class_3218)level, DespawnReason.CAPTURED);
    }

    public final void handle(@NotNull PokemonFaintedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastDespawns()) {
            return;
        }
        if (!evt.getPokemon().isWild()) {
            return;
        }
        PokemonEntity pokemonEntity = evt.getPokemon().getEntity();
        if (pokemonEntity == null) {
            return;
        }
        PokemonEntity entity = pokemonEntity;
        class_2338 coords = entity.method_24515();
        class_1937 level = entity.method_37908();
        if (!(level instanceof class_3218)) {
            return;
        }
        Pokemon pokemon = evt.getPokemon();
        Intrinsics.checkNotNullExpressionValue((Object)coords, (String)"coords");
        class_2960 class_29602 = ((class_5321)level.method_23753(coords).method_40230().get()).method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"level.getBiome(coords).key.get().value");
        class_2960 class_29603 = ((class_3218)level).method_44013().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"level.dimensionKey.value");
        this.broadcast(pokemon, coords, class_29602, class_29603, (class_3218)level, DespawnReason.FAINTED);
    }

    public final void handle(@NotNull class_1297 entity, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastVolatileDespawns()) {
            return;
        }
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        class_2338 coords = ((PokemonEntity)entity).method_24515();
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        Intrinsics.checkNotNullExpressionValue((Object)coords, (String)"coords");
        class_2960 class_29602 = ((class_5321)level.method_23753(coords).method_40230().get()).method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"level.getBiome(coords).key.get().value");
        class_2960 class_29603 = level.method_44013().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"level.dimensionKey.value");
        this.broadcast(pokemon, coords, class_29602, class_29603, level, DespawnReason.DESPAWNED);
    }

    private final void broadcast(Pokemon pokemon, class_2338 coords, class_2960 biome, class_2960 dimension, class_3218 level, DespawnReason reason) {
        block4: {
            class_2561 class_25612 = new DespawnBroadcaster(pokemon, CobblemonSpawnPools.INSTANCE.getWORLD_SPAWN_POOL(), coords, biome, dimension, reason).getBroadcast();
            if (class_25612 == null) break block4;
            class_2561 message = class_25612;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
            } else if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                class_5321 class_53212 = level.method_44013();
                Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"level.dimensionKey");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((class_5321<class_2874>)class_53212, coords), message);
            } else {
                Broadcast.INSTANCE.broadcastMessage(level, message);
            }
        }
    }
}

